"use server"
import outputs from '@/../amplify_outputs.json';
import { Schema } from '@/aws-data-schema';

import { generateServerClientUsingCookies } from "@aws-amplify/adapter-nextjs/api";
import { cookies } from "next/headers";
import { transformListUsersResult } from './transformers';
import { AppUserGroup } from '@/zod/amplify.schema';

const client = generateServerClientUsingCookies<Schema>({
  cookies: cookies,
  config: outputs
})

export const listAllUsers = async () => {
  const res = await client.queries.listAllUsers()
  return transformListUsersResult(res)
};

export const inviteUser = async (email: string, agencyid: string, group: AppUserGroup) => {
  const res = await client.mutations.inviteNewUser({
    email: email,
    agencyid: agencyid,
    groupName: group
  })
  return res
}

export const revokeUser = async (email: string) => {
  const res = await client.mutations.deleteUser({
    email: email,
  })
  return res
}

export type AmplifyListUsersResult = Awaited<ReturnType<typeof client.queries.listAllUsers>>

